# Intuition
<!-- Describe your first thoughts on how to solve this problem. -->

# Approach
<!-- Describe your approach to solving the problem. -->
- Using binary search ( for $$O(logn)$$ )
- - Found the first occurence of target 
- - Found the first occurence of number just greater than target 
- - subtracted '1' from it to get the last occurence of target
---
Have a look at the code , still have any confusion then please let me know in the comments
Keep Solving.:)

# Complexity
- Time complexity : $$O(logn)$$
<!-- Add your time complexity here, e.g. $$O(n)$$ -->

- Space complexity : $$O(1)$$
<!-- Add your space complexity here, e.g. $$O(n)$$ -->

# Code
```
class Solution {
    public int[] searchRange(int[] nums, int target) {

        int f = firstGreaterEqual(nums, target);
        if( f == nums.length || nums[f] != target){
            return new int[] {-1, -1};
        }
        // Now for last occurence of target : find the firstGreaterEqual of its just greater number : the last index of target will be '1' before that
        int l = firstGreaterEqual(nums, target+1) - 1;
        return new int[] { f, l};
    }

    static int firstGreaterEqual( int[] nums, int target){ // binary search to find the first occurence of target or the occurence of number just greater than it
        int l = 0;
        int r = nums.length;
        while( l < r){
            int mid = (l+r) / 2;
            if( nums[mid] >= target){
                r = mid;
            }else{
                l = mid + 1;
            }
        }
        return l;
    }
}
```